/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.ClauseEntry;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.util.OneToManyMap;

public class RuleStore {
    protected OneToManyMap<Node, Rule> goalMap = new OneToManyMap();
    protected List<Rule> allRules;
    protected Set<Rule> ruleIndex = new HashSet<Rule>();

    public RuleStore() {
        this.allRules = new ArrayList<Rule>();
    }

    public RuleStore(List<Rule> rules) {
        for (Rule rule : rules) {
            this.addRule(rule);
        }
        this.allRules = rules;
    }

    public void addAll(RuleStore store) {
        for (Rule rule : store.getAllRules()) {
            this.addRule(rule);
        }
    }

    public void addRule(Rule rule) {
        this.addRemoveRule(rule, true);
    }

    public void deleteRule(Rule rule) {
        this.addRemoveRule(rule, false);
    }

    private void addRemoveRule(Rule rule, boolean isAdd) {
        if (rule.headLength() != 1) {
            for (int j = 0; j < rule.headLength(); ++j) {
                Rule newRule = new Rule(rule.getName(), new ClauseEntry[]{rule.getHeadElement(j)}, rule.getBody());
                newRule.setNumVars(rule.getNumVars());
                this.doAddRemoveRule(newRule, isAdd);
            }
        } else {
            this.doAddRemoveRule(rule, isAdd);
        }
    }

    protected void doAddRemoveRule(Rule rule, boolean isAdd) {
        ClauseEntry headClause;
        if (isAdd && this.ruleIndex.contains(rule)) {
            return;
        }
        if (isAdd) {
            this.ruleIndex.add(rule);
            if (this.allRules != null) {
                this.allRules.add(rule);
            }
        } else {
            this.ruleIndex.remove(rule);
            if (this.allRules != null) {
                this.allRules.remove(rule);
            }
        }
        if ((headClause = rule.getHeadElement(0)) instanceof TriplePattern) {
            TriplePattern headpattern = (TriplePattern)headClause;
            Node predicate = headpattern.getPredicate();
            if (predicate.isVariable()) {
                if (isAdd) {
                    this.goalMap.put(Node.ANY, rule);
                } else {
                    this.goalMap.remove(Node.ANY, rule);
                }
            } else if (isAdd) {
                this.goalMap.put(predicate, rule);
            } else {
                this.goalMap.remove(predicate, rule);
            }
        }
    }

    public List<Rule> rulesFor(TriplePattern goal) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        if (goal.getPredicate().isVariable()) {
            this.checkAll(this.goalMap.values().iterator(), goal, rules);
        } else {
            this.checkAll(this.goalMap.getAll(goal.getPredicate()), goal, rules);
            this.checkAll(this.goalMap.getAll(Node.ANY), goal, rules);
        }
        return rules;
    }

    public List<Rule> getAllRules() {
        return this.allRules;
    }

    public void deleteAllRules() {
        this.allRules.clear();
        this.goalMap.clear();
        this.ruleIndex.clear();
    }

    private void checkAll(Iterator<Rule> candidates, TriplePattern goal, List<Rule> matchingRules) {
        while (candidates.hasNext()) {
            Rule r = candidates.next();
            if (!((TriplePattern)r.getHeadElement(0)).compatibleWith(goal)) continue;
            matchingRules.add(r);
        }
    }
}

