C$Id$

c     Modifications (c) 2021 Advanced Micro Devices, Inc. All Rights Reserved.

C #ifndef VERY_VERBOSE
C #define VERY_VERBOSE   1
C #endif

C #ifndef DEBUG_TRIPLESX
C #define DEBUG_TRIPLESX 1
C #endif

#ifdef USE_OMP_TEAMS_DISTRIBUTE
#define TEAMS_DISTRIBUTE teams distribute
#else
#define TEAMS_DISTRIBUTE
#endif

#ifdef USE_OMP_SCHEDULE_STATIC_1
#define OMP_SCHEDULE schedule(static,1)
#else
#define OMP_SCHEDULE
#endif

#ifdef DEBUG_TRIPLESX
#ifndef OFFLOAD_CODE
      subroutine debug_triplesx_d(triplesx, l_triplesx)
      implicit none
      external offload_enabled
      logical offload_enabled
      integer l_triplesx
      integer it
      double precision triplesx(l_triplesx)
      double precision res
      res = 0d0
      if (offload_enabled()) then
!$omp target TEAMS_DISTRIBUTE parallel do map(tofrom:res)
        do it=1,l_triplesx
          res = res + triplesx(it)
        enddo
!$omp end target teams distribute parallel do
      else
        do it=1,l_triplesx
          res = res + triplesx(it)
        enddo
      endif
      write (*,*) 'res D triplesx:', res
      end
#endif
#endif

#ifdef OFFLOAD_CODE
#ifdef AOMP_MAPPING_FIXED
c     the mapping functions won't be needed
#else
      subroutine offl_dbl_map(array, sz)
        double precision array(sz)
        integer sz
!$omp target enter data map(to:array)
      end subroutine
      subroutine offl_dbl_unmap(array, sz)
        double precision array(sz)
        integer sz
!$omp target exit data map(from:array)
      end subroutine
#endif
#endif

#ifdef OFFLOAD_CODE
      SUBROUTINE offl0_ccsd_t_doubles_l_12(d_a,k_a_offset,
#else
      SUBROUTINE ccsd_t_doubles_l_12(d_a,k_a_offset,
#endif
     &d_b,k_b_offset,triplesx,t_p4
     &b,t_p5b,t_p6b,t_h1b,t_h2b,t_h3b,
     T     v2sub,t2sub,scratch)
C     This is a Fortran77 program generated by Tensor Contraction Engine v.1.0
C     Copyright (c) Battelle & Pacific Northwest National Laboratory (2002)
C     i0 ( p4 p5 p6 h1 h2 h3 )_vt + = -1 * P( 9 ) * Sum ( h7 ) * t ( p4 p5 h1 h7 )_t * v ( h7 p6 h2 h3 )_v
c
c elimination of the transpositions (kowalski,august,2009)
c
      IMPLICIT NONE
#include "global.fh"
#include "mafdecls.fh"
#include "sym.fh"
#include "errquit.fh"
#include "tce.fh"
#include "ccsd_t_ps.fh"
#include "util.fh"
#include "offl.fh"
      INTEGER d_a
      INTEGER k_a_offset
      INTEGER d_b
      INTEGER k_b_offset
      INTEGER t_p4b
      INTEGER t_p5b
      INTEGER t_p6b
      INTEGER t_h1b
      INTEGER t_h2b
      INTEGER t_h3b
      INTEGER p4b
      INTEGER p5b
      INTEGER p6b
      INTEGER h1b
      INTEGER h2b
      INTEGER h3b
      INTEGER dimc
      INTEGER l_c_sort
      INTEGER k_c_sort
      INTEGER h7b,p7b
      integer p5b_2,p7b_1,h2b_1,p7b_2
      INTEGER p4b_1
      INTEGER p5b_1
      INTEGER h1b_1
      INTEGER h7b_1
      INTEGER p6b_2
      INTEGER h7b_2
      INTEGER h2b_2
      INTEGER h3b_2
      INTEGER dim_common
      INTEGER dima_sort
      INTEGER dima
      INTEGER dimb_sort
      INTEGER dimb
      INTEGER l_a
      INTEGER k_a
      INTEGER l_b
      INTEGER k_b
c -- peta-exa --
      INTEGER a3(9,6)
      INTEGER ia6,ja6
c --------------
      DOUBLE PRECISION triplesx(*)
c --------------
      INTEGER k_range_h3b_1
      INTEGER k_range_h2b_1
      INTEGER k_range_h1b_1
      INTEGER k_range_p6b_1
      INTEGER k_range_p5b_1
      INTEGER k_range_p4b_1
      INTEGER k_range_h7b_1
      INTEGER k_range_p7b_1
      INTEGER k_a_srt_len
      INTEGER k_b_srt_len
C #ifdef OFFLOAD_CODE
      integer l_t2sub,l_triplesx,l_v2sub
C #endif
      double precision t2sub(*),v2sub(*),scratch(*)
      logical tce_hashnsort,lresult
      external tce_hashnsort
      logical tce_hashnsort_2
      external tce_hashnsort_2
      integer n_h7b
      integer n_p7b
      double precision t0
      integer deltat_mic,deltat_off
#ifdef USE_OPENMP
      double precision omp_get_wtime
      external omp_get_wtime
#endif
      integer h7b_in,p7b_in

C #ifdef OFFLOAD_CODE
cfrom l_triplesx
      l_triplesx=
     c int_mb(k_range+t_h3b-1)*
     c int_mb(k_range+t_h2b-1)*
     c int_mb(k_range+t_h1b-1)*
     c int_mb(k_range+t_p6b-1)*
     c int_mb(k_range+t_p5b-1)*
     c int_mb(k_range+t_p4b-1)
      call ccsd_t_v2t2lgth(l_t2sub,l_v2sub)
C #endif

        a3(1,1)=t_p4b
        a3(1,2)=t_p5b
        a3(1,3)=t_p6b
        a3(1,4)=t_h1b
        a3(1,5)=t_h2b
        a3(1,6)=t_h3b
c
        a3(2,1)=t_p4b
        a3(2,2)=t_p5b
        a3(2,3)=t_p6b
        a3(2,4)=t_h2b
        a3(2,5)=t_h1b
        a3(2,6)=t_h3b
c
        a3(3,1)=t_p4b
        a3(3,2)=t_p5b
        a3(3,3)=t_p6b
        a3(3,4)=t_h3b
        a3(3,5)=t_h1b
        a3(3,6)=t_h2b
c
        a3(4,1)=t_p5b
        a3(4,2)=t_p6b
        a3(4,3)=t_p4b
        a3(4,4)=t_h1b
        a3(4,5)=t_h2b
        a3(4,6)=t_h3b
c
        a3(5,1)=t_p5b
        a3(5,2)=t_p6b
        a3(5,3)=t_p4b
        a3(5,4)=t_h2b
        a3(5,5)=t_h1b
        a3(5,6)=t_h3b
c
        a3(6,1)=t_p5b
        a3(6,2)=t_p6b
        a3(6,3)=t_p4b
        a3(6,4)=t_h3b
        a3(6,5)=t_h1b
        a3(6,6)=t_h2b
c
        a3(7,1)=t_p4b
        a3(7,2)=t_p6b
        a3(7,3)=t_p5b
        a3(7,4)=t_h1b
        a3(7,5)=t_h2b
        a3(7,6)=t_h3b
c
        a3(8,1)=t_p4b
        a3(8,2)=t_p6b
        a3(8,3)=t_p5b
        a3(8,4)=t_h2b
        a3(8,5)=t_h1b
        a3(8,6)=t_h3b
c
        a3(9,1)=t_p4b
        a3(9,2)=t_p6b
        a3(9,3)=t_p5b
        a3(9,4)=t_h3b
        a3(9,5)=t_h1b
        a3(9,6)=t_h2b
c
#ifdef VERY_VERBOSE
      write (*,'(A)',advance="no") ':'
#endif

        do ia6=1,8
         if(a3(ia6,1).ne.0) then
         do ja6=ia6+1,9
          if((a3(ia6,1).eq.a3(ja6,1)).and.(a3(ia6,2).eq.a3(ja6,2))
     &     .and.(a3(ia6,3).eq.a3(ja6,3)).and.(a3(ia6,4).eq.a3(ja6,4))
     &     .and.(a3(ia6,5).eq.a3(ja6,5)).and.(a3(ia6,6).eq.a3(ja6,6)))
     &     then
           a3(ja6,1)=0
           a3(ja6,2)=0
           a3(ja6,3)=0
           a3(ja6,4)=0
           a3(ja6,5)=0
           a3(ja6,6)=0
          end if
         enddo
         end if
      enddo
c
#ifdef TCE_OPENACC
!$acc  enter data copyin(scratch(1:l_t2sub))
!$acc& copyin(t2sub(1:l_t2sub))
!$acc& copyin(v2sub(1:l_v2sub))
#else
#ifdef OFFLOAD_CODE
#ifdef AOMP_MAPPING_FIXED
!$omp target data map(alloc:scratch(1:l_t2sub))
#else
      call offl_dbl_map(scratch, l_t2sub)
#endif
#endif
#endif
      do ia6=1,9
      p4b=a3(ia6,1)
      p5b=a3(ia6,2)
      p6b=a3(ia6,3)
      h1b=a3(ia6,4)
      h2b=a3(ia6,5)
      h3b=a3(ia6,6)
      if(((p4b.le.p5b).and.(h2b.le.h3b).and.(p4b.ne.0)).and.
     A ((.not.restricted).or.(int_mb(k_spin+p4b-1)+int_mb(k_spin+p5b-1
     &)+int_mb(k_spin+p6b-1)+int_mb(k_spin+h1b-1)+int_mb(k_spin+h2b-1)+i
     &nt_mb(k_spin+h3b-1).ne.12)).and.
     A (int_mb(k_spin+p4b-1)+int_mb(k_spin+p5b-1)+int_mb(k_spin+p6b-1)
     & .eq. int_mb(k_spin+h1b-1)+int_mb(k_spin+h2b-1)+int_mb(k_spin+h3b-
     &1)).and.
     A (ieor(int_mb(k_sym+p4b-1),ieor(int_mb(k_sym+p5b-1),ieor(int_mb(
     &k_sym+p6b-1),ieor(int_mb(k_sym+h1b-1),ieor(int_mb(k_sym+h2b-1),int
     &_mb(k_sym+h3b-1)))))) .eq. ieor(irrep_v,irrep_t))) THEN

      dimc = int_mb(k_range+p4b-1) * int_mb(k_range+p5b-1) * int_mb(k_ra
     &nge+p6b-1) * int_mb(k_range+h1b-1) * int_mb(k_range+h2b-1) * int_m
     &b(k_range+h3b-1)
c
c
cfrom l_triplesx
      k_range_h3b_1 = int_mb(k_range+h3b-1)
      k_range_h2b_1 = int_mb(k_range+h2b-1)
      k_range_h1b_1 = int_mb(k_range+h1b-1)
      k_range_p6b_1 = int_mb(k_range+p6b-1)
      k_range_p5b_1 = int_mb(k_range+p5b-1)
      k_range_p4b_1 = int_mb(k_range+p4b-1)

c     prep. work
c     figure out  cycles to work on
      n_h7b=0
      DO h7b = 1,noab
         if(tce_hashnsort(.true.,
     d        d_a, d_b,
     I        k_a_offset,k_b_offset,
     I        p4b,p5b,h1b,h7b,
     I        p6b,h2b,h3b,
     O        t2sub,v2sub
     P        )) then
            n_h7b=n_h7b+1
         endif
      enddo

      if(n_h7b.gt.0) then

#if 0
         do h7b=1,noab
#else
         do h7b_in=ga_nodeid()+1,ga_nodeid()+noab
            h7b=mod(h7b_in,noab)+1
#endif
            if(tce_hashnsort(.false.,
     d           d_a, d_b,
     I           k_a_offset,k_b_offset,
     I           p4b,p5b,h1b,h7b,
     I           p6b,h2b,h3b,
     O           t2sub,v2sub)) then
            k_range_h7b_1 = int_mb(k_range+h7b-1)
#ifdef VERY_VERBOSE
      write (*,'(A)',advance="no") '+'
#endif
#ifdef OFFLOAD_CODE
#if AOMP_MAPPING_FIXED
!$omp target data map(to:t2sub(1:l_t2sub)) map(to:v2sub(1:l_v2sub))
#else
      call offl_dbl_map(t2sub, l_t2sub)
      call offl_dbl_map(v2sub, l_v2sub)
#endif
#endif

#ifdef TCE_OPENACC
!$acc update device(t2sub(1:l_t2sub))      
!$acc update device(v2sub(1:l_v2sub))      
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p5b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h2b) .and. (t_h3b .eq. h
     &3b)) THEN
         call acc_sd_t_d1_1(k_range_h3b_1,k_range_h2b_1,
     1     k_range_h1b_1,k_range_p6b_1,
     2     k_range_p5b_1,k_range_p4b_1,
     3     k_range_h7b_1,
     4     triplesx,t2sub,v2sub)
      END IF
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p5b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h2b) .and. (t_h2b .eq. h1b) .and. (t_h3b .eq. h
     &3b)) THEN
         call acc_sd_t_d1_2(k_range_h3b_1,k_range_h2b_1,
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_h7b_1,
     4        triplesx,t2sub,v2sub)
      END IF
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p5b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h2b) .and. (t_h2b .eq. h3b) .and. (t_h3b .eq. h
     &1b)) THEN
         call acc_sd_t_d1_3(k_range_h3b_1,k_range_h2b_1,
     1     k_range_h1b_1,k_range_p6b_1,
     2     k_range_p5b_1,k_range_p4b_1,
     3     k_range_h7b_1,
     4     triplesx,t2sub,v2sub)
       END IF
      IF ((t_p4b .eq. p6b) .and. (t_p5b .eq. p4b) .and. (t_p6b .eq. p5b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h2b) .and. (t_h3b .eq. h
     &3b)) THEN
         call acc_sd_t_d1_4(k_range_h3b_1,k_range_h2b_1,
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_h7b_1,
     4        triplesx,t2sub,v2sub)
      END IF
      IF ((t_p4b .eq. p6b) .and. (t_p5b .eq. p4b) .and. (t_p6b .eq. p5b)
     & .and. (t_h1b .eq. h2b) .and. (t_h2b .eq. h1b) .and. (t_h3b .eq. h
     &3b)) THEN
         call acc_sd_t_d1_5(k_range_h3b_1,k_range_h2b_1,
     1     k_range_h1b_1,k_range_p6b_1,
     2     k_range_p5b_1,k_range_p4b_1,
     3     k_range_h7b_1,
     4     triplesx,t2sub,v2sub)
      END IF
      IF ((t_p4b .eq. p6b) .and. (t_p5b .eq. p4b) .and. (t_p6b .eq. p5b)
     & .and. (t_h1b .eq. h2b) .and. (t_h2b .eq. h3b) .and. (t_h3b .eq. h
     &1b)) THEN
         call acc_sd_t_d1_6(k_range_h3b_1,k_range_h2b_1,
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_h7b_1,
     4        triplesx,t2sub,v2sub)
      END IF
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p6b) .and. (t_p6b .eq. p5b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h2b) .and. (t_h3b .eq. h
     &3b)) THEN
         call acc_sd_t_d1_7(k_range_h3b_1,k_range_h2b_1,
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_h7b_1,
     4        triplesx,t2sub,v2sub)
      END IF
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p6b) .and. (t_p6b .eq. p5b)
     & .and. (t_h1b .eq. h2b) .and. (t_h2b .eq. h1b) .and. (t_h3b .eq. h
     &3b)) THEN
         call acc_sd_t_d1_8(k_range_h3b_1,k_range_h2b_1,
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_h7b_1,
     4        triplesx,t2sub,v2sub)
      END IF
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p6b) .and. (t_p6b .eq. p5b)
     & .and. (t_h1b .eq. h2b) .and. (t_h2b .eq. h3b) .and. (t_h3b .eq. h
     &1b)) THEN
         call acc_sd_t_d1_9(k_range_h3b_1,k_range_h2b_1,
     1     k_range_h1b_1,k_range_p6b_1,
     2     k_range_p5b_1,k_range_p4b_1,
     3     k_range_h7b_1,
     4     triplesx,t2sub,v2sub)
      END IF

c if not using TCE_OPENACC:      
#else 

      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p5b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h2b) .and. (t_h3b .eq. h
     &3b)) THEN
c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d1_1(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d1_1(k_range_h3b_1,k_range_h2b_1,
#endif
     1     k_range_h1b_1,k_range_p6b_1,
     2     k_range_p5b_1,k_range_p4b_1,
     3     k_range_h7b_1,
     4     triplesx,t2sub,v2sub,
     d     deltat_mic)
c         call tce_sdtime(t0,deltat_mic,
c     ,     fdist_sdkrnl11,fdist_sdcomp11)
      END IF
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p5b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h2b) .and. (t_h2b .eq. h1b) .and. (t_h3b .eq. h
     &3b)) THEN
c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d1_2(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d1_2(k_range_h3b_1,k_range_h2b_1,
#endif
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_h7b_1,
     4        triplesx,t2sub,v2sub,scratch,
     D        deltat_mic)
c      call tce_sdtime(t0,deltat_mic,
c     ,        fdist_sdkrnl12,fdist_sdcomp12)
      END IF
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p5b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h2b) .and. (t_h2b .eq. h3b) .and. (t_h3b .eq. h
     &1b)) THEN
c      call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
      call offl_sdtransp_t_d1_3(k_range_h3b_1,k_range_h2b_1,
#else
      call sdtransp_t_d1_3(k_range_h3b_1,k_range_h2b_1,
#endif
     1     k_range_h1b_1,k_range_p6b_1,
     2     k_range_p5b_1,k_range_p4b_1,
     3     k_range_h7b_1,
     4     triplesx,t2sub,v2sub,scratch,
     D     deltat_mic)
c      call tce_sdtime(t0,deltat_mic,
c     ,     fdist_sdkrnl13,fdist_sdcomp13)
       END IF
      IF ((t_p4b .eq. p6b) .and. (t_p5b .eq. p4b) .and. (t_p6b .eq. p5b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h2b) .and. (t_h3b .eq. h
     &3b)) THEN
c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d1_4(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d1_4(k_range_h3b_1,k_range_h2b_1,
#endif
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_h7b_1,
     4        triplesx,t2sub,v2sub,
     D        deltat_mic)
c         call tce_sdtime(t0,deltat_mic,
c     ,        fdist_sdkrnl14,fdist_sdcomp14)
      END IF
      IF ((t_p4b .eq. p6b) .and. (t_p5b .eq. p4b) .and. (t_p6b .eq. p5b)
     & .and. (t_h1b .eq. h2b) .and. (t_h2b .eq. h1b) .and. (t_h3b .eq. h
     &3b)) THEN
c      call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
      call offl_sdtransp_t_d1_5(k_range_h3b_1,k_range_h2b_1,
#else
      call sdtransp_t_d1_5(k_range_h3b_1,k_range_h2b_1,
#endif
     1     k_range_h1b_1,k_range_p6b_1,
     2     k_range_p5b_1,k_range_p4b_1,
     3     k_range_h7b_1,
     4     triplesx,t2sub,v2sub,scratch,
     D     deltat_mic)
c      call tce_sdtime(t0,deltat_mic,
c     ,     fdist_sdkrnl15,fdist_sdcomp15)
      END IF
      IF ((t_p4b .eq. p6b) .and. (t_p5b .eq. p4b) .and. (t_p6b .eq. p5b)
     & .and. (t_h1b .eq. h2b) .and. (t_h2b .eq. h3b) .and. (t_h3b .eq. h
     &1b)) THEN
c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d1_6(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d1_6(k_range_h3b_1,k_range_h2b_1,
#endif
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_h7b_1,
     4        triplesx,t2sub,v2sub,scratch,
     D        deltat_mic)
c         call tce_sdtime(t0,deltat_mic,
c     ,        fdist_sdkrnl16,fdist_sdcomp16)
      END IF
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p6b) .and. (t_p6b .eq. p5b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h2b) .and. (t_h3b .eq. h
     &3b)) THEN
c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d1_7(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d1_7(k_range_h3b_1,k_range_h2b_1,
#endif
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_h7b_1,
     4        triplesx,t2sub,v2sub,
     D        deltat_mic)
c         call tce_sdtime(t0,deltat_mic,
c     ,        fdist_sdkrnl17,fdist_sdcomp17)
      END IF
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p6b) .and. (t_p6b .eq. p5b)
     & .and. (t_h1b .eq. h2b) .and. (t_h2b .eq. h1b) .and. (t_h3b .eq. h
     &3b)) THEN
c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d1_8(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d1_8(k_range_h3b_1,k_range_h2b_1,
#endif
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_h7b_1,
     4        triplesx,t2sub,v2sub,scratch,
     D        deltat_mic)
c         call tce_sdtime(t0,deltat_mic,
c     ,        fdist_sdkrnl18,fdist_sdcomp18)
      END IF
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p6b) .and. (t_p6b .eq. p5b)
     & .and. (t_h1b .eq. h2b) .and. (t_h2b .eq. h3b) .and. (t_h3b .eq. h
     &1b)) THEN
c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d1_9(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d1_9(k_range_h3b_1,k_range_h2b_1,
#endif
     1     k_range_h1b_1,k_range_p6b_1,
     2     k_range_p5b_1,k_range_p4b_1,
     3     k_range_h7b_1,
     4     triplesx,t2sub,v2sub,scratch,
     D     deltat_mic)
c         call tce_sdtime(t0,deltat_mic,
c     ,        fdist_sdkrnl19,fdist_sdcomp19)
      END IF
c end if using using TCE_OPENACC kernels
#endif


#ifdef OFFLOAD_CODE
#if AOMP_MAPPING_FIXED
c     unmap(to:t2sub(1:l_t2sub)) unmap(to:v2sub(1:l_v2sub))
!$omp end target data
#else
      call offl_dbl_unmap(t2sub, l_t2sub)
      call offl_dbl_unmap(v2sub, l_v2sub)
#endif
#endif
      endif
      END DO !h7b loop
      endif ! n_h7b.ne.0
c
c
      END IF
      END DO !ia6 loop

cold      SUBROUTINE ccsd_t_doubles_l_2(d_a,k_a_offset,
c
        a3(1,1)=t_p4b
        a3(1,2)=t_p5b
        a3(1,3)=t_p6b
        a3(1,4)=t_h1b
        a3(1,5)=t_h2b
        a3(1,6)=t_h3b
c
        a3(2,1)=t_p4b
        a3(2,2)=t_p5b
        a3(2,3)=t_p6b
        a3(2,4)=t_h2b
        a3(2,5)=t_h3b
        a3(2,6)=t_h1b
c
        a3(3,1)=t_p4b
        a3(3,2)=t_p5b
        a3(3,3)=t_p6b
        a3(3,4)=t_h1b
        a3(3,5)=t_h3b
        a3(3,6)=t_h2b
c
        a3(4,1)=t_p5b
        a3(4,2)=t_p4b
        a3(4,3)=t_p6b
        a3(4,4)=t_h1b
        a3(4,5)=t_h2b
        a3(4,6)=t_h3b
c
        a3(5,1)=t_p5b
        a3(5,2)=t_p4b
        a3(5,3)=t_p6b
        a3(5,4)=t_h2b
        a3(5,5)=t_h3b
        a3(5,6)=t_h1b
c
        a3(6,1)=t_p5b
        a3(6,2)=t_p4b
        a3(6,3)=t_p6b
        a3(6,4)=t_h1b
        a3(6,5)=t_h3b
        a3(6,6)=t_h2b
c
        a3(7,1)=t_p6b
        a3(7,2)=t_p4b
        a3(7,3)=t_p5b
        a3(7,4)=t_h1b
        a3(7,5)=t_h2b
        a3(7,6)=t_h3b
c
        a3(8,1)=t_p6b
        a3(8,2)=t_p4b
        a3(8,3)=t_p5b
        a3(8,4)=t_h2b
        a3(8,5)=t_h3b
        a3(8,6)=t_h1b
c
        a3(9,1)=t_p6b
        a3(9,2)=t_p4b
        a3(9,3)=t_p5b
        a3(9,4)=t_h1b
        a3(9,5)=t_h3b
        a3(9,6)=t_h2b
c
        do ia6=1,8
         if(a3(ia6,1).ne.0) then
         do ja6=ia6+1,9
          if((a3(ia6,1).eq.a3(ja6,1)).and.(a3(ia6,2).eq.a3(ja6,2))
     &     .and.(a3(ia6,3).eq.a3(ja6,3)).and.(a3(ia6,4).eq.a3(ja6,4))
     &     .and.(a3(ia6,5).eq.a3(ja6,5)).and.(a3(ia6,6).eq.a3(ja6,6)))
     &     then
           a3(ja6,1)=0
           a3(ja6,2)=0
           a3(ja6,3)=0
           a3(ja6,4)=0
           a3(ja6,5)=0
           a3(ja6,6)=0
          end if
         enddo
         end if
        enddo
c
      do ia6=1,9
      p4b=a3(ia6,1)
      p5b=a3(ia6,2)
      p6b=a3(ia6,3)
      h1b=a3(ia6,4)
      h2b=a3(ia6,5)
      h3b=a3(ia6,6)
      if(((p5b.le.p6b).and.(h1b.le.h2b).and.(p4b.ne.0)).and.
     A ((.not.restricted).or.(int_mb(k_spin+p4b-1)+int_mb(k_spin+p5b-1
     &)+int_mb(k_spin+p6b-1)+int_mb(k_spin+h1b-1)+int_mb(k_spin+h2b-1)+i
     &nt_mb(k_spin+h3b-1).ne.12)).and.
     A (int_mb(k_spin+p4b-1)+int_mb(k_spin+p5b-1)+int_mb(k_spin+p6b-1)
     & .eq. int_mb(k_spin+h1b-1)+int_mb(k_spin+h2b-1)+int_mb(k_spin+h3b-
     &1)).and.
     A (ieor(int_mb(k_sym+p4b-1),ieor(int_mb(k_sym+p5b-1),ieor(int_mb(
     &k_sym+p6b-1),ieor(int_mb(k_sym+h1b-1),ieor(int_mb(k_sym+h2b-1),int
     &_mb(k_sym+h3b-1)))))) .eq. ieor(irrep_v,irrep_t))) THEN
      dimc = int_mb(k_range+p4b-1) * int_mb(k_range+p5b-1) * int_mb(k_ra
     &nge+p6b-1) * int_mb(k_range+h1b-1) * int_mb(k_range+h2b-1) * int_m
     &b(k_range+h3b-1)
cfrom l_triplesx
      k_range_h3b_1 = int_mb(k_range+h3b-1)
      k_range_h2b_1 = int_mb(k_range+h2b-1)
      k_range_h1b_1 = int_mb(k_range+h1b-1)
      k_range_p6b_1 = int_mb(k_range+p6b-1)
      k_range_p5b_1 = int_mb(k_range+p5b-1)
      k_range_p4b_1 = int_mb(k_range+p4b-1)
c     prep. work
c     figure out  cycles to work on
      n_p7b=0
      DO p7b = noab+1,noab+nvab
         if(tce_hashnsort_2(.true.,
     d        d_a, d_b,
     I        k_a_offset,k_b_offset,
     I        p4b,p7b,h1b,h2b,
     I        p5b,p6b,h3b,
     O        t2sub,v2sub
     P        )) then
            n_p7b=n_p7b+1
         endif
      enddo

      if(n_p7b.ne.0) then

#if 0
      do p7b= noab+1,noab+nvab
#else
      do p7b_in= ga_nodeid()+1,nvab+ga_nodeid()
         p7b=mod(p7b_in,nvab)+noab+1
#endif
         if(tce_hashnsort_2(.false.,
     d        d_a, d_b,
     I        k_a_offset,k_b_offset,
     I        p4b,p7b,h1b,h2b,
     I        p5b,p6b,h3b,
     O        t2sub,v2sub)) then

            k_range_p7b_1 = int_mb(k_range+p7b-1)
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") '='
#endif
#ifdef TCE_OPENACC
!$acc update device(t2sub(1:l_t2sub))      
!$acc update device(v2sub(1:l_v2sub))      
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p5b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h2b) .and. (t_h3b .eq. h
     &3b)) THEN
         call acc_sd_t_d2_1(k_range_h3b_1,k_range_h2b_1,
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub)
      END IF
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p5b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h3b) .and. (t_h2b .eq. h1b) .and. (t_h3b .eq. h
     &2b)) THEN
         call acc_sd_t_d2_2(k_range_h3b_1,k_range_h2b_1,
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub)
      END IF
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p5b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h3b) .and. (t_h3b .eq. h
     &2b)) THEN
         call acc_sd_t_d2_3(k_range_h3b_1,k_range_h2b_1,
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub)
      END IF
      IF ((t_p4b .eq. p5b) .and. (t_p5b .eq. p4b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h2b) .and. (t_h3b .eq. h
     &3b)) THEN
         call acc_sd_t_d2_4(k_range_h3b_1,k_range_h2b_1,
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub)
      END IF
      IF ((t_p4b .eq. p5b) .and. (t_p5b .eq. p4b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h3b) .and. (t_h2b .eq. h1b) .and. (t_h3b .eq. h
     &2b)) THEN
         call acc_sd_t_d2_5(k_range_h3b_1,k_range_h2b_1,
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub)
      END IF
      IF ((t_p4b .eq. p5b) .and. (t_p5b .eq. p4b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h3b) .and. (t_h3b .eq. h
     &2b)) THEN
         call acc_sd_t_d2_6(k_range_h3b_1,k_range_h2b_1,
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub)
      END IF
      IF ((t_p4b .eq. p5b) .and. (t_p5b .eq. p6b) .and. (t_p6b .eq. p4b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h2b) .and. (t_h3b .eq. h
     &3b)) THEN
         call acc_sd_t_d2_7(k_range_h3b_1,k_range_h2b_1,
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub)
      END IF
      IF ((t_p4b .eq. p5b) .and. (t_p5b .eq. p6b) .and. (t_p6b .eq. p4b)
     & .and. (t_h1b .eq. h3b) .and. (t_h2b .eq. h1b) .and. (t_h3b .eq. h
     &2b)) THEN
         call acc_sd_t_d2_8(k_range_h3b_1,k_range_h2b_1,
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub)
      END IF
      IF ((t_p4b .eq. p5b) .and. (t_p5b .eq. p6b) .and. (t_p6b .eq. p4b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h3b) .and. (t_h3b .eq. h
     &2b)) THEN
         call acc_sd_t_d2_9(k_range_h3b_1,k_range_h2b_1,
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub)
      END IF

c else if not using OPENACC kernels
#else
#ifdef OFFLOAD_CODE
#if AOMP_MAPPING_FIXED
!$omp target data map(to:t2sub(1:l_t2sub)) map(to:v2sub(1:l_v2sub))
#else
      call offl_dbl_map(t2sub, l_t2sub)
      call offl_dbl_map(v2sub, l_v2sub)
#endif
#endif
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p5b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h2b) .and. (t_h3b .eq. h
     &3b)) THEN
c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d2_1(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d2_1(k_range_h3b_1,k_range_h2b_1,
#endif
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub,scratch,
     D        deltat_mic)
c         call tce_sdtime(t0,deltat_mic,
c     ,        fdist_sdkrnl21,fdist_sdcomp21)
      END IF
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p5b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h3b) .and. (t_h2b .eq. h1b) .and. (t_h3b .eq. h
     &2b)) THEN
c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d2_2(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d2_2(k_range_h3b_1,k_range_h2b_1,
#endif
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub,scratch,
     D        deltat_mic)
c         call tce_sdtime(t0,deltat_mic,
c     ,        fdist_sdkrnl22,fdist_sdcomp22)
      END IF
      IF ((t_p4b .eq. p4b) .and. (t_p5b .eq. p5b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h3b) .and. (t_h3b .eq. h
     &2b)) THEN
c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d2_3(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d2_3(k_range_h3b_1,k_range_h2b_1,
#endif
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub,
     D        deltat_mic)
c         call tce_sdtime(t0,deltat_mic,
c     ,        fdist_sdkrnl23,fdist_sdcomp23)
      END IF
      IF ((t_p4b .eq. p5b) .and. (t_p5b .eq. p4b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h2b) .and. (t_h3b .eq. h
     &3b)) THEN
c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d2_4(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d2_4(k_range_h3b_1,k_range_h2b_1,
#endif
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub,scratch,
     D        deltat_mic)
c         call tce_sdtime(t0,deltat_mic,
c     ,        fdist_sdkrnl24,fdist_sdcomp24)
      END IF
      IF ((t_p4b .eq. p5b) .and. (t_p5b .eq. p4b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h3b) .and. (t_h2b .eq. h1b) .and. (t_h3b .eq. h
     &2b)) THEN

c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d2_5(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d2_5(k_range_h3b_1,k_range_h2b_1,
#endif
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub,scratch,
     D        deltat_mic)
c         call tce_sdtime(t0,deltat_mic,
c     ,        fdist_sdkrnl25,fdist_sdcomp25)
      END IF
      IF ((t_p4b .eq. p5b) .and. (t_p5b .eq. p4b) .and. (t_p6b .eq. p6b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h3b) .and. (t_h3b .eq. h
     &2b)) THEN
c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d2_6(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d2_6(k_range_h3b_1,k_range_h2b_1,
#endif
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub,scratch,
     D        deltat_mic)
c         call tce_sdtime(t0,deltat_mic,
c     ,        fdist_sdkrnl26,fdist_sdcomp26)
      END IF
      IF ((t_p4b .eq. p5b) .and. (t_p5b .eq. p6b) .and. (t_p6b .eq. p4b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h2b) .and. (t_h3b .eq. h
     &3b)) THEN
c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d2_7(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d2_7(k_range_h3b_1,k_range_h2b_1,
#endif
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub,
     D        deltat_mic)
c         call tce_sdtime(t0,deltat_mic,
c     ,        fdist_sdkrnl27,fdist_sdcomp27)
      END IF
      IF ((t_p4b .eq. p5b) .and. (t_p5b .eq. p6b) .and. (t_p6b .eq. p4b)
     & .and. (t_h1b .eq. h3b) .and. (t_h2b .eq. h1b) .and. (t_h3b .eq. h
     &2b)) THEN
c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d2_8(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d2_8(k_range_h3b_1,k_range_h2b_1,
#endif
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub,scratch,
     D        deltat_mic)
c         call tce_sdtime(t0,deltat_mic,
c     ,        fdist_sdkrnl28,fdist_sdcomp28)
      END IF
      IF ((t_p4b .eq. p5b) .and. (t_p5b .eq. p6b) .and. (t_p6b .eq. p4b)
     & .and. (t_h1b .eq. h1b) .and. (t_h2b .eq. h3b) .and. (t_h3b .eq. h
     &2b)) THEN
c        call tce_sdtime0(t0)
#ifdef OFFLOAD_CODE
         call offl_sdtransp_t_d2_9(k_range_h3b_1,k_range_h2b_1,
#else
         call sdtransp_t_d2_9(k_range_h3b_1,k_range_h2b_1,
#endif
     1        k_range_h1b_1,k_range_p6b_1,
     2        k_range_p5b_1,k_range_p4b_1,
     3        k_range_p7b_1,
     4        triplesx,t2sub,v2sub,scratch,
     D        deltat_mic)
c         call tce_sdtime(t0,deltat_mic,
c     ,        fdist_sdkrnl29,fdist_sdcomp29)
      END IF

#endif
#ifdef OFFLOAD_CODE
#ifdef AOMP_MAPPING_FIXED
c     unmap(to:t2sub(1:l_t2sub)) unmap(to:v2sub(1:l_v2sub))
!$omp end target data
#else
      call offl_dbl_unmap(t2sub, l_t2sub)
      call offl_dbl_unmap(v2sub, l_v2sub)
#endif
#endif
      endif
      END DO ! p7b loop

      endif ! n_p7b.ne.0
c
c
      END IF
      END DO ! ia6 loop

#ifdef TCE_OPENACC
!$acc  exit data delete(t2sub(1:l_t2sub))
!$acc& delete(v2sub(1:l_v2sub))
!$acc& delete(scratch(1:l_t2sub))
#else

#ifdef OFFLOAD_CODE
#ifdef AOMP_MAPPING_FIXED
c     unmap(to:scratch(1:l_t2sub))
!$omp end target data
#else
      call offl_dbl_unmap(scratch, l_t2sub)
#endif
#endif
#ifdef DEBUG_TRIPLESX
      call debug_triplesx_d(triplesx, l_triplesx)
#endif
#endif
      RETURN
      END

#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d1_1(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d1_1(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               h7d,
     2               triplesx,t2sub,v2sub,
     3     deltat)
      IMPLICIT NONE
      integer h3d,h2d,h1d,p6d,p5d,p4d,h7d
      integer h3,h2,h1,p6,p5,p4,h7
      integer h2h3
      double precision triplesx(h3d*h2d,h1d,p6d,p5d,p4d)
      double precision t2sub(h7d,p4d,p5d,h1d)
      double precision v2sub(h3d*h2d,p6d,h7d)
#include "sd_top.fh"
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") '1'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p4,p5,p6,h2,h3,h1,h7)
!$omp&collapse(OMPCOLLAPSE) OMP_SCHEDULE
#else
!$omp parallel do private(p4,p5,p6,h2,h3,h1,h7) collapse(OMPCOLLAPSE)
#endif
      do p4=1,p4d
      do p5=1,p5d
      do p6=1,p6d
      do h1=1,h1d
!DEC$ LOOP COUNT MAX=40, MIN=8
cz!DEC$ unroll_and_jam (2)
      do h7=1,h7d
!DEC$ LOOP COUNT MAX=600, MIN=30
      do h2h3=1,h3d*h2d
       triplesx(h2h3,h1,p6,p5,p4)=triplesx(h2h3,h1,p6,p5,p4)
     1   - t2sub(h7,p4,p5,h1)*v2sub(h2h3,p6,h7)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d1_2(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d1_2(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               h7d,
     2               triplesx,t2sub,v2sub,scratch,
     3     deltat)
      IMPLICIT NONE
      integer h3d,h2d,h1d,p6d,p5d,p4d,h7d
      integer h3,h2,h1,p6,p5,p4,h7
      double precision triplesx(h3d,h1d,h2d,p6d,p5d,p4d)
      double precision t2sub(h7d,p4d,p5d,h1d)
      double precision scratch(h7d,h3d,h2d,p6d)
      double precision v2sub(*)
#ifdef OFFLOAD_CODE
      external offl_ccsd_t_transpt2_7326
#else
      external ccsd_t_transpt2_7326
#endif
#include "sd_top.fh"
CDIR$ NOINLINE
#ifdef OFFLOAD_CODE
      call offl_ccsd_t_transpt2_7326(
#else
      call ccsd_t_transpt2_7326(
#endif
     T        v2sub,scratch,
     1     h3d,h2d,p6d,h7d)
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") '2'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p4,p5,p6,h2,h3,h1,h7)
!$omp&collapse(4) OMP_SCHEDULE
#else
!$omp parallel do private(p4,p5,p6,h2,h3,h1,h7) collapse(4)
#endif
      do p4=1,p4d
      do p5=1,p5d
      do p6=1,p6d
      do h2=1,h2d
      do h1=1,h1d
!DEC$ LOOP COUNT MAX=40, MIN=8
c!DEC$ unroll_and_jam (4)
      do h3=1,h3d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do h7=1,h7d
       triplesx(h3,h1,h2,p6,p5,p4)=triplesx(h3,h1,h2,p6,p5,p4)
     1   + t2sub(h7,p4,p5,h1)*scratch(h7,h3,h2,p6)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d1_3(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d1_3(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               h7d,
     2               triplesx,t2sub,v2sub,scratch,
     3     deltat)
      IMPLICIT NONE

      integer h3d,h2d,h1d,p6d,p5d,p4d,h7d
      integer h3,h2,h1,p6,p5,p4,h7
      integer h3h2
      double precision triplesx(h1d,h3d*h2d,p6d,p5d,p4d)
      double precision scratch(h7d,h3d*h2d,p6d)
c      double precision v2sub(h3d*h2d,p6d,h7d)
      double precision t2sub(h7d,p4d,p5d,h1d)
      double precision v2sub(h3d,h2d,p6d,h7d)
#ifdef OFFLOAD_CODE
      external offl_ccsd_t_transpt2_7326
#else
      external ccsd_t_transpt2_7326
#endif
#include "sd_top.fh"
CDIR$ NOINLINE
#ifdef OFFLOAD_CODE
      call offl_ccsd_t_transpt2_7326(
#else
      call ccsd_t_transpt2_7326(
#endif
     T        v2sub,scratch,
     1     h3d,h2d,p6d,h7d)
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") '3'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p4,p5,p6,h3h2,h1,h7)
!$omp&collapse(OMPCOLLAPSE) OMP_SCHEDULE
#else
!$omp parallel do private(p4,p5,p6,h3h2,h1,h7) collapse(OMPCOLLAPSE)
#endif
      do p4=1,p4d
      do p5=1,p5d
      do p6=1,p6d
!DEC$ LOOP COUNT MAX=600, MIN=30
      do h3h2=1,h3d*h2d
!DEC$ LOOP COUNT MAX=40, MIN=8
c!DEC$ unroll_and_jam (4)
      do h1=1,h1d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do h7=1,h7d
       triplesx(h1,h3h2,p6,p5,p4)=triplesx(h1,h3h2,p6,p5,p4)
     1   - t2sub(h7,p4,p5,h1)*scratch(h7,h3h2,p6)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d1_4(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d1_4(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               h7d,
     2               triplesx,t2sub,v2sub,
     D     deltat)
      IMPLICIT NONE

      integer h3d,h2d,h1d,p6d,p5d,p4d,h7d
      integer h3,h2,h1,p6,p5,p4,h7
      integer h2h3
      double precision triplesx(h3d*h2d,h1d,p5d,p4d,p6d)
      double precision t2sub(h7d,p4d,p5d,h1d)
      double precision v2sub(h3d*h2d,p6d,h7d)
#include "sd_top.fh"
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") '4'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p4,p5,p6,h2,h3,h1,h7)
!$omp&collapse(OMPCOLLAPSE) OMP_SCHEDULE
#else
!$omp parallel do private(p4,p5,p6,h2,h3,h1,h7) collapse(OMPCOLLAPSE)
#endif
      do p6=1,p6d
      do p4=1,p4d
      do p5=1,p5d
      do h1=1,h1d
      do h7=1,h7d
!DEC$ LOOP COUNT MAX=600, MIN=30
      do h2h3=1,h2d*h3d
       triplesx(h2h3,h1,p5,p4,p6)=triplesx(h2h3,h1,p5,p4,p6)
     1   - t2sub(h7,p4,p5,h1)*v2sub(h2h3,p6,h7)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d1_5(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d1_5(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               h7d,
     2               triplesx,t2sub,v2sub,scratch,
     d     deltat)
      IMPLICIT NONE

      integer h3d,h2d,h1d,p6d,p5d,p4d,h7d
      integer h3,h2,h1,p6,p5,p4,h7
      double precision triplesx(h3d,h1d,h2d,p5d,p4d,p6d)
      double precision scratch(h7d,h3d,h2d,p6d)
      double precision t2sub(h7d,p4d,p5d,h1d)
      double precision v2sub(h3d,h2d,p6d,h7d)
#ifdef OFFLOAD_CODE
      external offl_ccsd_t_transpt2_7326
#else
      external ccsd_t_transpt2_7326
#endif
#include "sd_top.fh"
CDIR$ NOINLINE
#ifdef OFFLOAD_CODE
      call offl_ccsd_t_transpt2_7326(
#else
      call ccsd_t_transpt2_7326(
#endif
     T        v2sub,scratch,
     1     h3d,h2d,p6d,h7d)
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") '5'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p4,p5,p6,h3,h2,h1,h7)
!$omp&collapse(OMPCOLLAPSE) OMP_SCHEDULE
#else
!$omp parallel do private(p4,p5,p6,h3,h2,h1,h7) collapse(OMPCOLLAPSE)
#endif
      do p6=1,p6d
      do p4=1,p4d
      do p5=1,p5d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do h2=1,h2d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do h1=1,h1d
!DEC$ LOOP COUNT MAX=40, MIN=8
!DEC$ unroll_and_jam (2)
      do h3=1,h3d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do h7=1,h7d
       triplesx(h3,h1,h2,p5,p4,p6)=triplesx(h3,h1,h2,p5,p4,p6)
     1    + t2sub(h7,p4,p5,h1)*scratch(h7,h3,h2,p6)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d1_6(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d1_6(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               h7d,
     2               triplesx,t2sub,v2sub,scratch,
     3     deltat)
      IMPLICIT NONE

      integer h3d,h2d,h1d,p6d,p5d,p4d,h7d
      integer h3,h2,h1,p6,p5,p4,h7
      integer h2h3
      double precision triplesx(h1d,h3d*h2d,p5d,p4d,p6d)
      double precision scratch(h7d,h3d*h2d,p6d)
      double precision t2sub(h7d,p4d,p5d,h1d)
      double precision v2sub(*)
#ifdef OFFLOAD_CODE
      external offl_ccsd_t_transpt2_7326
#else
      external ccsd_t_transpt2_7326
#endif
#include "sd_top.fh"
CDIR$ NOINLINE
#ifdef OFFLOAD_CODE
      call offl_ccsd_t_transpt2_7326(
#else
      call ccsd_t_transpt2_7326(
#endif
     T        v2sub,scratch,
     1     h3d,h2d,p6d,h7d)
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") '6'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p4,p5,p6,h2h3,h1,h7)
!$omp&collapse(OMPCOLLAPSE) OMP_SCHEDULE
#else
!$omp parallel do private(p4,p5,p6,h2h3,h1,h7) collapse(OMPCOLLAPSE)
#endif
      do p6=1,p6d
      do p4=1,p4d
      do p5=1,p5d
!DEC$ LOOP COUNT MAX=900, MIN=30
      do h2h3=1,h2d*h3d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do h1=1,h1d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do h7=1,h7d
       triplesx(h1,h2h3,p5,p4,p6)=triplesx(h1,h2h3,p5,p4,p6)
     1   - t2sub(h7,p4,p5,h1)*scratch(h7,h2h3,p6)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d1_7(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d1_7(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               h7d,
     2               triplesx,t2sub,v2sub,
     3     deltat)
      IMPLICIT NONE

      integer h3d,h2d,h1d,p6d,p5d,p4d,h7d
      integer h3,h2,h1,p6,p5,p4,h7
      integer h2h3
      double precision triplesx(h3d*h2d,h1d,p5d,p6d,p4d)
      double precision t2sub(h7d,p4d,p5d,h1d)
      double precision v2sub(h3d*h2d,p6d,h7d)
#include "sd_top.fh"
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") '7'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p4,p5,p6,h2,h3,h1,h7)
!$omp&collapse(OMPCOLLAPSE) OMP_SCHEDULE
#else
!$omp parallel do private(p4,p5,p6,h2,h3,h1,h7) collapse(OMPCOLLAPSE)
#endif
      do p4=1,p4d
      do p6=1,p6d
      do p5=1,p5d
      do h1=1,h1d
      do h7=1,h7d
!DEC$ LOOP COUNT MAX=600, MIN=30
      do h2h3=1,h2d*h3d
       triplesx(h2h3,h1,p5,p6,p4)=triplesx(h2h3,h1,p5,p6,p4)
     1   + t2sub(h7,p4,p5,h1)*v2sub(h2h3,p6,h7)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d1_8(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d1_8(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               h7d,
     2               triplesx,t2sub,v2sub,scratch,
     3     deltat)
      IMPLICIT NONE
      integer h3d,h2d,h1d,p6d,p5d,p4d,h7d
      integer h3,h2,h1,p6,p5,p4,h7
      double precision triplesx(h3d,h1d,h2d,p5d,p6d,p4d)
      double precision t2sub(h7d,p4d,p5d,h1d)
      double precision v2sub(*)
      double precision scratch(h7d,h3d,h2d,p6d)
#ifdef OFFLOAD_CODE
      external offl_ccsd_t_transpt2_7326
#else
      external ccsd_t_transpt2_7326
#endif
#include "sd_top.fh"
CDIR$ NOINLINE
#ifdef OFFLOAD_CODE
      call offl_ccsd_t_transpt2_7326(
#else
      call ccsd_t_transpt2_7326(
#endif
     T        v2sub,scratch,
     1     h3d,h2d,p6d,h7d)
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") '8'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p4,p5,p6,h2,h3,h1,h7)
!$omp&collapse(OMPCOLLAPSE) OMP_SCHEDULE
#else
!$omp parallel do private(p4,p5,p6,h2,h3,h1,h7) collapse(OMPCOLLAPSE)
#endif
      do p4=1,p4d
      do p6=1,p6d
      do p5=1,p5d
      do h2=1,h2d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do h1=1,h1d
!DEC$ LOOP COUNT MAX=40, MIN=8
c!DEC$ unroll_and_jam (2)
      do h3=1,h3d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do h7=1,h7d
       triplesx(h3,h1,h2,p5,p6,p4)=triplesx(h3,h1,h2,p5,p6,p4)
     1   - t2sub(h7,p4,p5,h1)*scratch(h7,h3,h2,p6)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d1_9(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d1_9(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               h7d,
     2               triplesx,t2sub,v2sub,scratch,
     3     deltat)
      IMPLICIT NONE

      integer h3d,h2d,h1d,p6d,p5d,p4d,h7d
      integer h3,h2,h1,p6,p5,p4,h7
      integer h3h2
      double precision triplesx(h1d,h3d*h2d,p5d,p6d,p4d)
      double precision scratch(h7d,h3d*h2d,p6d)
      double precision t2sub(h7d,p4d,p5d,h1d)
      double precision v2sub(*)
#ifdef OFFLOAD_CODE
      external offl_ccsd_t_transpt2_7326
#else
      external ccsd_t_transpt2_7326
#endif
#include "sd_top.fh"
CDIR$ NOINLINE
#ifdef OFFLOAD_CODE
      call offl_ccsd_t_transpt2_7326(
#else
      call ccsd_t_transpt2_7326(
#endif
     T        v2sub,scratch,
     1     h3d,h2d,p6d,h7d)
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") '9'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p4,p5,p6,h3h2,h1,h7)
!$omp&collapse(OMPCOLLAPSE) OMP_SCHEDULE
#else
!$omp parallel do private(p4,p5,p6,h3h2,h1,h7) collapse(OMPCOLLAPSE)
#endif
      do p4=1,p4d
      do p6=1,p6d
      do p5=1,p5d
!DEC$ LOOP COUNT MAX=900, MIN=30
      do h3h2=1,h3d*h2d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do h1=1,h1d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do h7=1,h7d
       triplesx(h1,h3h2,p5,p6,p4)=triplesx(h1,h3h2,p5,p6,p4)
     1   + t2sub(h7,p4,p5,h1)*scratch(h7,h3h2,p6)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d2_1(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d2_1(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               p7d,
     2               triplesx,t2sub,v2sub,scratch,
     D     deltat)
      IMPLICIT NONE

      integer h3d,h2d,h1d,p6d,p5d,p4d,p7d
      integer h3,h2,h1,p6,p5,p4,p7
      double precision triplesx(h3d,h2d,h1d,p6d,p5d,p4d)
      double precision scratch(p7d,h2d,h1d,p4d),t2sub(*)
      double precision v2sub(p7d,h3d,p6d,p5d)
#ifdef OFFLOAD_CODE
      external offl_ccsd_t_transpt2_7124
#else
      external ccsd_t_transpt2_7124
#endif
#include "sd2_top.fh"
#ifdef OFFLOAD_CODE
      call offl_ccsd_t_transpt2_7124(
#else
      call ccsd_t_transpt2_7124(
#endif
     T        t2sub,scratch,
     2     p4d, h1d, h2d, p7d)
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") 'a'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p4,p5,p6,h2,h1,h3,p7)
!$omp&collapse(OMPCOLLAPSE) OMP_SCHEDULE
#else
!$omp parallel do private(p4,p5,p6,h2,h1,h3,p7) collapse(OMPCOLLAPSE)
#endif
      do p4=1,p4d
      do p5=1,p5d
      do p6=1,p6d
      do h3=1,h3d
      do h1=1,h1d
!DEC$ LOOP COUNT MAX=40, MIN=8
!DEC$ unroll_and_jam (4)
      do h2=1,h2d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do p7=1,p7d
       triplesx(h3,h2,h1,p6,p5,p4)=triplesx(h3,h2,h1,p6,p5,p4)
     1   - scratch(p7,h2,h1,p4)*v2sub(p7,h3,p6,p5)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d2_2(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d2_2(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               p7d,
     2               triplesx,t2sub,v2sub,scratch,
     D     deltat)
      IMPLICIT NONE

      integer h3d,h2d,h1d,p6d,p5d,p4d,p7d
      integer h3,h2,h1,p6,p5,p4,p7
      integer h2h1
      double precision triplesx(h2d*h1d,h3d,p6d,p5d,p4d)
      double precision scratch(h2d*h1d,p4d,p7d),t2sub(*)
      double precision v2sub(p7d,h3d,p6d,p5d)
#ifdef OFFLOAD_CODE
      external offl_ccsd_t_transpt2
#else
      external ccsd_t_transpt2
#endif
#include "sd2_top.fh"
CDIR$ NOINLINE
#ifdef OFFLOAD_CODE
      call offl_ccsd_t_transpt2(
#else
      call ccsd_t_transpt2(
#endif
     T        t2sub,scratch,
     1     h2d,h1d,p4d,p7d)
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") 'b'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p4,p5,p6,h2h1,h3,p7)
!$omp&collapse(OMPCOLLAPSE) OMP_SCHEDULE
#else
!$omp parallel do private(p4,p5,p6,h2h1,h3,p7) collapse(OMPCOLLAPSE)
#endif
      do p4=1,p4d
      do p5=1,p5d
      do p6=1,p6d
      do h3=1,h3d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do p7=1,p7d
!DEC$ LOOP COUNT MAX=600, MIN=30
      do h2h1=1,h2d*h1d
       triplesx(h2h1,h3,p6,p5,p4)=triplesx(h2h1,h3,p6,p5,p4)
     1   - scratch(h2h1,p4,p7)*v2sub(p7,h3,p6,p5)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d2_3(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d2_3(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               p7d,
     2               triplesx,t2sub,v2sub,
     D     deltat)
      IMPLICIT NONE

      integer h3d,h2d,h1d,p6d,p5d,p4d,p7d
      integer h3,h2,h1,p6,p5,p4,p7
      double precision triplesx(h2d,h3d,h1d,p6d,p5d,p4d)
      double precision t2sub(p7d,p4d,h1d,h2d)
      double precision v2sub(p7d,h3d,p6d,p5d)
      double precision scratch(p7d,h2d,h1d,p4d)
#ifdef OFFLOAD_CODE
      external offl_ccsd_t_transpt2_7124
#else
      external ccsd_t_transpt2_7124
#endif
#include "sd2_top.fh"
CDIR$ NOINLINE
#ifdef OFFLOAD_CODE
      call offl_ccsd_t_transpt2_7124(
#else
      call ccsd_t_transpt2_7124(
#endif
     T        t2sub,scratch,
     1     p4d,h1d,h2d,p7d)
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") 'c'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p5,p6,p4,h1,h3,h2,p7)
!$omp&collapse(4) OMP_SCHEDULE
#else
!$omp parallel do private(p5,p6,p4,h1,h3,h2,p7) collapse(4)
#endif
      do p4=1,p4d
      do p5=1,p5d
      do p6=1,p6d
      do h1=1,h1d
      do h3=1,h3d
!DEC$ LOOP COUNT MAX=40, MIN=8
!DEC$ unroll_and_jam (4)
      do h2=1,h2d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do p7=1,p7d
       triplesx(h2,h3,h1,p6,p5,p4)=triplesx(h2,h3,h1,p6,p5,p4) +
     C        scratch(p7,h2,h1,p4)*v2sub(p7,h3,p6,p5)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d2_4(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d2_4(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               p7d,
     2               triplesx,t2sub,v2sub,scratch,
     D     deltat)
      IMPLICIT NONE

      integer h3d,h2d,h1d,p6d,p5d,p4d,p7d
      integer h3,h2,h1,p6,p5,p4,p7
      double precision triplesx(h3d,h2d,h1d,p6d,p4d,p5d)
      double precision scratch(p7d,h2d,h1d,p4d),t2sub(*)
      double precision v2sub(p7d,h3d,p6d,p5d)
#ifdef OFFLOAD_CODE
      external offl_ccsd_t_transpt2_7124
#else
      external ccsd_t_transpt2_7124
#endif
#include "sd2_top.fh"
CDIR$ NOINLINE
#ifdef OFFLOAD_CODE
      call offl_ccsd_t_transpt2_7124(
#else
      call ccsd_t_transpt2_7124(
#endif
     T        t2sub,scratch,
     2     p4d, h1d, h2d, p7d)
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") 'd'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p4,p5,p6,h2,h1,h3,p7)
!$omp&collapse(4) OMP_SCHEDULE
#else
!$omp parallel do private(p4,p5,p6,h2,h1,h3,p7) collapse(4)
#endif
      do p5=1,p5d
      do p4=1,p4d
      do p6=1,p6d
      do h1=1,h1d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do h2=1,h2d
!DEC$ LOOP COUNT MAX=40, MIN=8
!DEC$ unroll_and_jam (1)
      do h3=1,h3d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do p7=1,p7d
       triplesx(h3,h2,h1,p6,p4,p5)=triplesx(h3,h2,h1,p6,p4,p5)
     1   + scratch(p7,h2,h1,p4)*v2sub(p7,h3,p6,p5)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d2_5(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d2_5(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               p7d,
     2               triplesx,t2sub,v2sub,scratch,
     D     deltat)
      IMPLICIT NONE

      integer h3d,h2d,h1d,p6d,p5d,p4d,p7d
      integer h3,h2,h1,p6,p5,p4,p7
      integer h2h1
      double precision triplesx(h2d*h1d,h3d,p6d,p4d,p5d)
      double precision scratch(h2d*h1d,p4d,p7d),t2sub(*)
      double precision v2sub(p7d,h3d,p6d,p5d)
#ifdef OFFLOAD_CODE
      external offl_ccsd_t_transpt2
#else
      external ccsd_t_transpt2
#endif
#include "sd2_top.fh"
CDIR$ NOINLINE
#ifdef OFFLOAD_CODE
      call offl_ccsd_t_transpt2(
#else
      call ccsd_t_transpt2(
#endif
     T        t2sub,scratch,
     1     h2d,h1d,p4d,p7d)
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") 'e'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p4,p5,p6,h2h1,h3,p7)
!$omp&collapse(OMPCOLLAPSE) OMP_SCHEDULE
#else
!$omp parallel do private(p4,p5,p6,h2h1,h3,p7) collapse(OMPCOLLAPSE)
#endif
      do p5=1,p5d
      do p4=1,p4d
      do p6=1,p6d
      do h3=1,h3d
!DEC$ LOOP COUNT MAX=40, MIN=8
!DEC$ unroll_and_jam (1)
      do p7=1,p7d
!DEC$ LOOP COUNT MAX=600, MIN=30
      do h2h1=1,h2d*h1d
       triplesx(h2h1,h3,p6,p4,p5)=triplesx(h2h1,h3,p6,p4,p5)
     1   + scratch(h2h1,p4,p7)*v2sub(p7,h3,p6,p5)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d2_6(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d2_6(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               p7d,
     2               triplesx,t2sub,v2sub,scratch,
     D     deltat)
      IMPLICIT NONE

      integer h3d,h2d,h1d,p6d,p5d,p4d,p7d
      integer h3,h2,h1,p6,p5,p4,p7
      double precision triplesx(h2d,h3d,h1d,p6d,p4d,p5d)
      double precision t2sub(p7d,p4d,h1d,h2d)
      double precision scratch(p7d,h2d,h1d,p4d)
      double precision v2sub(p7d,h3d,p6d,p5d)
#ifdef OFFLOAD_CODE
      external offl_ccsd_t_transpt2_7124
#else
      external ccsd_t_transpt2_7124
#endif
#include "sd2_top.fh"
#ifdef OFFLOAD_CODE
      call offl_ccsd_t_transpt2_7124(
#else
      call ccsd_t_transpt2_7124(
#endif
     T        t2sub,scratch,
     1     p4d,h1d,h2d,p7d)
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") 'f'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p5,p6,p4,h1,h3,h2,p7)
!$omp&collapse(4) OMP_SCHEDULE
#else
!$omp parallel do private(p5,p6,p4,h1,h3,h2,p7) collapse(4)
#endif
      do p5=1,p5d
      do p4=1,p4d
      do p6=1,p6d
      do h1=1,h1d
      do h3=1,h3d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do h2=1,h2d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do p7=1,p7d
       triplesx(h2,h3,h1,p6,p4,p5)=triplesx(h2,h3,h1,p6,p4,p5)
     1   - scratch(p7,h2,h1,p4)*v2sub(p7,h3,p6,p5)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d2_7(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d2_7(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               p7d,
     2               triplesx,t2sub,v2sub,
     D     deltat)
      IMPLICIT NONE

      integer h3d,h2d,h1d,p6d,p5d,p4d,p7d
      integer h3,h2,h1,p6,p5,p4,p7
      double precision triplesx(h3d,h2d,h1d,p4d,p6d,p5d)
      double precision t2sub(p7d,p4d,h1d,h2d)
      double precision scratch(p7d,h2d,h1d,p4d)
      double precision v2sub(p7d,h3d,p6d,p5d)
#ifdef OFFLOAD_CODE
      external offl_ccsd_t_transpt2_7124
#else
      external ccsd_t_transpt2_7124
#endif
#include "sd2_top.fh"
CDIR$ NOINLINE
#ifdef OFFLOAD_CODE
      call offl_ccsd_t_transpt2_7124(
#else
      call ccsd_t_transpt2_7124(
#endif
     T        t2sub,scratch,
     1     p4d,h1d,h2d,p7d)
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") 'g'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p5,p6,p4,h1,h3,h2,p7)
!$omp&collapse(4) OMP_SCHEDULE
#else
!$omp parallel do private(p5,p6,p4,h1,h3,h2,p7) collapse(4)
#endif
      do p5=1,p5d
      do p6=1,p6d
      do p4=1,p4d
      do h1=1,h1d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do h2=1,h2d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do h3=1,h3d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do p7=1,p7d
       triplesx(h3,h2,h1,p4,p6,p5)=triplesx(h3,h2,h1,p4,p6,p5)
     1   - scratch(p7,h2,h1,p4)*v2sub(p7,h3,p6,p5)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d2_8(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d2_8(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               p7d,
     2               triplesx,t2sub,v2sub,scratch,
     D     deltat)
      IMPLICIT NONE

      integer h3d,h2d,h1d,p6d,p5d,p4d,p7d
      integer h3,h2,h1,p6,p5,p4,p7
      integer h2h1
      double precision triplesx(h2d*h1d,h3d,p4d,p6d,p5d)
      double precision scratch(h2d*h1d,p4d,p7d),t2sub(*)
      double precision v2sub(p7d,h3d,p6d,p5d)
#ifdef OFFLOAD_CODE
      external offl_ccsd_t_transpt2
#else
      external ccsd_t_transpt2
#endif
#include "sd2_top.fh"
#ifdef OFFLOAD_CODE
      call offl_ccsd_t_transpt2(
#else
      call ccsd_t_transpt2(
#endif
     T        t2sub,scratch,
     1     h2d,h1d,p4d,p7d)
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") 'h'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p4,p5,p6,h2h1,h3,p7)
!$omp&collapse(OMPCOLLAPSE) OMP_SCHEDULE
#else
!$omp parallel do private(p4,p5,p6,h2h1,h3,p7) collapse(OMPCOLLAPSE)
#endif
      do p5=1,p5d
      do p6=1,p6d
      do p4=1,p4d
      do h3=1,h3d
!DEC$ LOOP COUNT MAX=40, MIN=8
!DEC$ unroll_and_jam (1)
      do p7=1,p7d
!DEC$ LOOP COUNT MAX=600, MIN=30
      do h2h1=1,h2d*h1d
       triplesx(h2h1,h3,p4,p6,p5)=triplesx(h2h1,h3,p4,p6,p5)
     1   - scratch(h2h1,p4,p7)*v2sub(p7,h3,p6,p5)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
c
#ifdef OFFLOAD_CODE
      subroutine offl_sdtransp_t_d2_9(h3d,h2d,h1d,p6d,p5d,p4d,
#else
      subroutine sdtransp_t_d2_9(h3d,h2d,h1d,p6d,p5d,p4d,
#endif
     1               p7d,
     2               triplesx,t2sub,v2sub,scratch,
     D     deltat)
      IMPLICIT NONE

      integer h3d,h2d,h1d,p6d,p5d,p4d,p7d
      integer h3,h2,h1,p6,p5,p4,p7
      double precision triplesx(h2d,h3d,h1d,p4d,p6d,p5d)
      double precision t2sub(p7d,p4d,h1d,h2d)
      double precision scratch(p7d,h2d,h1d,p4d)
      double precision v2sub(p7d,h3d,p6d,p5d)
#ifdef OFFLOAD_CODE
      external offl_ccsd_t_transpt2_7124
#else
      external ccsd_t_transpt2_7124
#endif
#include "sd2_top.fh"
CDIR$ NOINLINE
#ifdef OFFLOAD_CODE
      call offl_ccsd_t_transpt2_7124(
#else
      call ccsd_t_transpt2_7124(
#endif
     T        t2sub,scratch,
     1     p4d,h1d,h2d,p7d)
#ifdef OFFLOAD_CODE
#ifdef VERY_VERBOSE
      write (*, '(A)', advance="no") 'i'
#endif
!$omp target
!$omp TEAMS_DISTRIBUTE parallel do private(p5,p6,p4,h1,h3,h2,p7)
!$omp&collapse(4) OMP_SCHEDULE
#else
!$omp parallel do private(p5,p6,p4,h1,h3,h2,p7) collapse(4)
#endif
      do p5=1,p5d
      do p6=1,p6d
      do p4=1,p4d
      do h1=1,h1d
      do h3=1,h3d
!DEC$ LOOP COUNT MAX=40, MIN=8
!DEC$ unroll_and_jam (1)
      do h2=1,h2d
!DEC$ LOOP COUNT MAX=40, MIN=8
      do p7=1,p7d
       triplesx(h2,h3,h1,p4,p6,p5)=triplesx(h2,h3,h1,p4,p6,p5)
     1    + scratch(p7,h2,h1,p4)*v2sub(p7,h3,p6,p5)
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
      enddo
#ifdef OFFLOAD_CODE
!$omp end TEAMS_DISTRIBUTE parallel do
!$omp end target
#else
!$omp end parallel do
#endif
#include "sd_bottom.fh"
      return
      end
#ifndef OFFLOAD_CODE
#ifdef USE_OFFLOAD
#define OFFLOAD_CODE
c
c     Compile source again for offload code
c
#include "offl_ccsd_t_doubles_l.F"

#else
c wrong
       subroutine offl0_ccsd_t_doubles_l_12()
       call errquit(' offl0 l12: why am I here ...',0,0)
       end
#endif
#endif
