%feature("docstring") OT::LineSampling
R"RAW(Line sampling algorithm.

.. warning::
    This class is experimental and likely to be modified in future releases.
    To use it, import the ``openturns.experimental`` submodule.


This class implements the line sampling algorithm from [koutsourelakis2004]_ with adaptation
of the important direction from [angelis2015]_, which is also known as adaptive line sampling.

Let :math:`\inputRV` be a random vector of dimension :math:`\inputDim`, distributed according to
the measure :math:`\inputMeasure`, and :math:`\model: \Rset^\inputDim \rightarrow \Rset`
be the *limit state function* (where we only write the random input parameters).
We define the event :math:`\cD_f` by:

.. math::

    \cD_f = \{\vect{x} \in \Rset^{\inputDim} \, | \,\model(\vect{x}) \leq 0\}

The line sampling algorithm estimates the probability of the event :math:`\cD_f`:

.. math::

    P_f = \Prob{\model\left( \inputRV \right) \leq 0}
        = \int_{\Rset^{\inputDim}} \mathbf{1}_{\{\model(\vect{x}) \leq 0 \}}\inputMeasure(\vect{x})\di{\vect{x}}

Let :math:`T` be the iso-probabilistic transformation to the standard space: :math:`T(\vect{X}) = \vect{Z}`. The
random vector :math:`\vect{Z}` is a :math:`\inputDim`-dimensional Gaussian vector following the standard normal distribution.

For any direction :math:`\vect{\alpha} \in \Rset^d` such that :math:`||\vect{\alpha}||_2=1`,
let :math:`P_{\vect{\alpha}}` be the orthogonal projection from :math:`\Rset^d` to the one-dimensional vector space (line)
spanned by :math:`\vect{\alpha}` (we call :math:`\vect{\alpha}` the *important direction*)  and let :math:`P^{\perp}_{\vect{\alpha}}` be the orthogonal projection from :math:`\Rset^d`
to the hyperplane of :math:`\Rset^d` normal to the one-dimensional vector space spanned by :math:`\vect{\alpha}`.

Then :math:`P_f` can be rewritten:

.. math::

    P_f = \Expect{\Prob{P_{\vect{\alpha}}(\vect{Z}) + P^{\perp}_{\vect{\alpha}}(\vect{Z}) \in T(\cD_f) | P^{\perp}_{\vect{\alpha}}(\vect{Z})}}

Since :math:`\vect{Z}` follows a standard multivariate normal distribution, :math:`P_{\vect{\alpha}}(\vect{Z})`
and :math:`P^{\perp}_{\vect{\alpha}}(\vect{Z})` are independent.

Therefore, given that :math:`P_{\vect{\alpha}}(\vect{Z})` follows the same distribution as :math:`R \vect{\alpha}`
where :math:`R` is a scalar random variable following the standard normal distribution, we have:

.. math::

    P_f = \Expect{\Prob{R \vect{\alpha} + P^{\perp}_{\vect{\alpha}}(\vect{Z}) \in T(\cD_f) | P^{\perp}_{\vect{\alpha}}(\vect{Z})}}

Now, for any vector :math:`\vect{u} \in \Rset^d` that is orthogonal to :math:`\vect{\alpha}`,
we define :math:`I_u` as the set

.. math::

    I_u = \{ r \in \Rset, r \vect{\alpha} + u \in T(\cD_f) \}

We can rewrite

.. math::

    P_f = \Expect{\Prob{R \in I_{P_{\vect{\alpha}}(\vect{Z})} | P^{\perp}_{\vect{\alpha}}(\vect{Z}}}

Letting :math:`I_u^0` be the interior of :math:`I_u`, we assume :math:`I_u^0` to be the union
of a finite number of open intervals.

Then there exists :math:`n_u \in \Nset` and :math:`r_0, \hdots, r_{2 n_u + 1} \in \Rset \cup \{-\infty, +\infty\}` such that
:math:`r_0 < \hdots < r_{2 n_u + 1}` and :math:`I_u^0 = \bigcup_{i=0}^{n_u} (r_{2i}, r_{2i+1})`.

:math:`r_0` is either :math:`-\infty` or a root of :math:`r \mapsto g \circ T^{-1}(r \vect{\alpha} + u)`.
:math:`r_{2 n_u + 1}` is either :math:`+\infty` or a root of :math:`r \mapsto g \circ T^{-1}(r \vect{\alpha} + u)`.
All the other :math:`r_j` are roots of :math:`r \mapsto g \circ T^{-1}(r \vect{\alpha} + u)`.

With :math:`\Phi` denoting the CDF of the standard normal distribution we have

.. math::

    \Prob{R \in I_u} = \Prob{I_u^0} = \sum_{i=0}^{n_u} \Prob{r_{2 i} < R < r_{2 i + 1}} \\
                     = \sum_{i=0}^{n_u} \Prob{R < r_{2 i + 1}} - \Prob{R \leq r_{2 i}} \\
                     = \sum_{0 < i < 2 n_u + 1} (-1)^{j+1} \Phi(r_j)

The generic line sampling algorithm follows the steps for :math:`k=1, \hdots \sampleSize`:

- Draw a sample :math:`\vect{z_k} \sim Z` and project it on the hyperplane normal to :math:`\vect{\alpha}`
  to obtain :math:`P^{\perp}_{\vect{\alpha}}(\vect{z_k})`.

- Find the roots of :math:`r \mapsto g \circ T^{-1}(r \vect{\alpha} + P^{\perp}_{\vect{\alpha}}(\vect{z_k}))`.

- Use the roots to compute :math:`p_{\vect{z_k}} = \Prob{R \in I_{P^{\perp}_{\vect{\alpha}}(\vect{z_k})}}`.

The global probability :math:`P_f` is computed from all the :math:`p_{\vect{z_k}}` probabilities.

.. math::

    \widehat{P}_{f,LS} = \frac{1}{\sampleSize} \sum_{i=1}^{\sampleSize} p_{\vect{z_k}}

The adaptive variant of the algorithm consists in updating the important direction :math:`\vect{\alpha}`
by the selecting the direction given by the nearest intersection with the frontiers of :math:`\cD_f` from the origin
as given by the root search for each new line explored.

Parameters
----------
event : :class:`~openturns.RandomVector`
    Event we are computing the probability.
initialAlpha : sequence of float
    The initial important direction :math:`\vect{\alpha}`.
rootStrategy : :class:`~openturns.RootStrategy`, optional
    Strategy used to evaluate the frontiers of
    the event along each direction in the standard space.
    By default :class:`~openturns.SafeAndSlow`.

Notes
-----
Various :class:`~openturns.ResourceMap` entries allow for a more fine-grained control over the algorithm:

- The boolean entry `LineSampling-DefaultSearchOppositeDirection` sets the default value of the flag
  activating the additional search in the opposite direction of the important direction.
- The boolean entry `LineSampling-DefaultAdaptiveImportantDirection` sets the default value of the flag
  activating the use of adaptive important direction as opposed to a fixed important direction.

See also
--------
openturns.DirectionalSampling)RAW"

// ---------------------------------------------------------------------------

%feature("docstring") OT::LineSampling::setInitialAlpha
"Initial important direction accessor.

Parameters
----------
alpha : sequence of float
    Initial important direction."

// ---------------------------------------------------------------------------

%feature("docstring") OT::LineSampling::getInitialAlpha
"Initial important direction accessor.

Returns
-------
alpha : :class:`~openturns.Point`
    Initial important direction."

// ---------------------------------------------------------------------------

%feature("docstring") OT::LineSampling::setSearchOppositeDirection
"Opposite direction search flag accessor.

Parameters
----------
searchOppositeDirection : bool
    Whether to search in the opposite direction of the important direction."

// ---------------------------------------------------------------------------

%feature("docstring") OT::LineSampling::getSearchOppositeDirection
"Opposite direction search flag accessor.

Returns
-------
searchOppositeDirection : bool
    Whether to search in the opposite direction of the important direction."

// ---------------------------------------------------------------------

%feature("docstring") OT::LineSampling::setStoreHistory
"Accessor to the important direction history.

Parameters
----------
storeHistory : bool
    Whether to store alpha, root values and points histories."

// ---------------------------------------------------------------------

%feature("docstring") OT::LineSampling::getStoreHistory
"Accessor to the important direction history.

Returns
-------
storeHistory : bool
    Whether to store alpha, root values and points histories."

// ---------------------------------------------------------------------

%feature("docstring") OT::LineSampling::getAlphaHistory
"Accessor to the important direction history.

Returns
-------
alphaHistory : :class:`~openturns.Sample`
    Storage strategy used to store the important direction vectors during the simulation."

// ---------------------------------------------------------------------

%feature("docstring") OT::LineSampling::getRootValuesHistory
"Accessor to the root values history.

Returns
-------
rootValuesHistory : sequence of :class:`~openturns.Point`
    The list of root values for each line."

// ---------------------------------------------------------------------

%feature("docstring") OT::LineSampling::getRootPointsHistory
"Accessor to the root points history.

Returns
-------
rootPointsHistory : sequence of :class:`~openturns.Sample`
    The list of root points for each line."

// ---------------------------------------------------------------------

%feature("docstring") OT::LineSampling::setAdaptiveImportantDirection
"Accessor to the adaptive important direction flag.

Parameters
----------
adaptiveImportantDirection : bool
    Whether the important direction is adapted according to new design points."

// ---------------------------------------------------------------------

%feature("docstring") OT::LineSampling::getAdaptiveImportantDirection
"Accessor to the adaptive important direction flag.

Returns
-------
adaptiveImportantDirection : bool
    Whether the important direction is adapted according to new design points."

// ---------------------------------------------------------------------

%feature("docstring") OT::LineSampling::getRootStrategy
"Get the root strategy.

Returns
-------
strategy : :class:`~openturns.RootStrategy`
    Root strategy used to evaluate the frontiers of
    the event along each direction in the standard space."

// ---------------------------------------------------------------------

%feature("docstring") OT::LineSampling::setRootStrategy
"Set the root strategy.

Parameters
----------
strategy : :class:`~openturns.RootStrategy`
    Root strategy to evaluate the frontiers of
    the event along each direction in the standard space."
